/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef _mx_ether_h_
#define _mx_ether_h_

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/sockio.h>
#include <sys/mbuf.h>
#include <sys/kernel.h>
#include <sys/socket.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <net/ethernet.h>
#include <net/bpf.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>

#if MX_DARWIN_XX <= 7
/* kpi compat */
void in_delayed_cksum(struct mbuf *m);
typedef struct mbuf * mbuf_t;
#define mclbytes MCLBYTES
#define mhlen	 MHLEN

#define mbuf_setnext(m, next) (m)->m_next = (next)
#define mbuf_next(m) (m)->m_next
#define mbuf_setnextpkt(m, nextpkt) (m)->m_nextpkt = (nextpkt)
#define mbuf_freem_list m_freem_list
#define mbuf_freem 	m_freem
#define mbuf_adj	m_adj
#define mbuf_pkthdr_setlen(m, len)  	(m)->m_pkthdr.len = len
#define mbuf_pkthdr_len(m)		(m)->m_pkthdr.len
#define mbuf_setlen(m, len)  		(m)->m_len = len
#define mbuf_len(m)  			(m)->m_len
#define mbuf_free(m)			m_free((m))
#define MBUF_PKTHDR	M_PKTHDR
static inline int
mbuf_get_csum_requested(mbuf_t m, int *req, int *val)
{
	*req = m->m_pkthdr.csum_flags;
	return 0;
}

static inline void
mbuf_pullup(mbuf_t *m, size_t len)
{
	*m = m_pullup(*m, len);
}


static inline void
mbuf_outbound_finalize(struct mbuf *m, int dontcare, int offset)
{
	struct ip *ip;

	if ((m->m_pkthdr.csum_flags & (CSUM_DELAY_DATA)) == 0)
		return;

	while(offset > m->m_len) {
		offset -= m->m_len;
		m = m->m_next;
	}
	m->m_len -= offset;
	m->m_data += offset;
	ip = mtod(m, struct ip *);
	ip->ip_len = ntohs(ip->ip_len);
	in_delayed_cksum(m);
	ip->ip_len = htons(ip->ip_len);
	m->m_len += offset;
	m->m_data -= offset;	
}

#define mx_set_csum_good(m) do {					\
	(m)->m_pkthdr.csum_data  = 0xffff;			\
	(m)->m_pkthdr.csum_flags |= ( CSUM_DATA_VALID | CSUM_PSEUDO_HDR ); \
} while (0);

#else
#define mtod(m, t)	((t)(mbuf_data(m)))
u_short in_pseudo(u_int sum, u_int b, u_int c);
#define mx_set_csum_good(m) do {					\
	mbuf_set_csum_performed((m),				\
				MBUF_CSUM_DID_DATA | MBUF_CSUM_PSEUDO_HDR,\
				0xffff);				\
} while (0);
		
#endif


struct mx_ether_buffer_info {
	mbuf_t m;
};


struct mx_ether_arch {
	void *cpp_class;
};

#endif /* _mx_ether_h_ */

/*
  This file uses MX driver indentation.

  Local Variables:
  c-file-style:"linux"
  tab-width:8
  End:
*/
